﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0076_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

$GoogleChromeRegPath = "HKLM:\Software\Policies\Google\Chrome"
$DevToolsGenAiSettingsKey = "DevToolsGenAiSettings"
$DevToolsGenAiSettingsValue = 2
if(!(Test-Path $GoogleChromeRegPath)){
    Log-Message -message "$GoogleChromeRegPath registry path not found"
    New-Item -Path $GoogleChromeRegPath -Force | Out-Null
    Log-Message -message "$GoogleChromeRegPath registry path created"
    New-ItemProperty -Path $GoogleChromeRegPath -Name $DevToolsGenAiSettingsKey -Value $DevToolsGenAiSettingsValue -PropertyType DWORD -Force | Out-Null
    Log-Message -message "$DevToolsGenAiSettingsKey registry key created value $DevToolsGenAiSettingsValue "
} else {
    Log-Message -message "Checking value of $DevToolsGenAiSettingsKey registry key expecting $DevToolsGenAiSettingsValue"
    Try {
        $CreateThemesSettingsCheck = Get-ItemPropertyValue -Path $GoogleChromeRegPath -Name $DevToolsGenAiSettingsKey
        if($CreateThemesSettingsCheck -ne $DevToolsGenAiSettingsValue){
            Log-Message -message "$DevToolsGenAiSettingsKey configured incorrect value: $CreateThemesSettingsCheck"
            New-ItemProperty -Path $GoogleChromeRegPath -Name $DevToolsGenAiSettingsKey -Value $DevToolsGenAiSettingsValue -PropertyType DWORD -Force | Out-Null
            Log-Message -message "Set $DevToolsGenAiSettingsKey value: $DevToolsGenAiSettingsValue"

        } else {
            Log-Message -message "$DevToolsGenAiSettingsKey properly configued. No changes needed"
        }
    } Catch {
        Log-Message -message "The property does not exist or an error occurred: $_"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $DevToolsGenAiSettingsKey -Value $DevToolsGenAiSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $DevToolsGenAiSettingsKey value: $DevToolsGenAiSettingsValue"
    }
}